# Amazon Payment Services PHP SDK
<a href="https://paymentservices.amazon.com/" target="_blank">Amazon Payment Services</a> SDK offers seamless payments for PHP platform merchants.  If you don't have an APS account click [here](https://paymentservices.amazon.com/) to sign up for Amazon Payment Services account.


## Getting Started
We know that payment processing is critical to your business. With this plugin we aim to increase your payment processing capabilities. Do you have a business-critical questions? View our quick reference [documentation](https://paymentservices.amazon.com/docs/EN/index.html) for key insights covering payment acceptance, integration, and reporting.


## Payment Options

* Integration Types
    * Redirection
    * Merchant Page
    * Hosted Merchant Page
    * Apple Pay
    * Installments
    * Recurring
    * MOTO
    * Trusted

* Maintenance Operations
    * Signature Calculation and Validation
    * Refund
    * Capture
    * Void
    * Check Status
    * Feedback Notification handling


## Changelog

| Plugin Version | Release Notes |
| :---: | :--- |
| 2.0.0 |   * Integrated checkout experience options: Redirection, Merchant Page, Hosted Merchant Page, Apple Pay, Installments, Recurring, MOTO, Trusted <br/> * Partial/Full Refund, Single/Multiple Capture and Void events <br/> * Signature calculation and validation <br/> * Check Status as a function <br/> Feedback notification handling| 

## API Documentation
This SDK has been implemented by using following [API library](https://paymentservices-reference.payfort.com/docs/api/build/index.html)

## Further Questions
Have any questions? Just get in [touch](https://paymentservices.amazon.com/get-in-touch)

## License
Released under the [MIT License](/LICENSE).
