<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>InfixLMS</title>
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
        href="https://fonts.googleapis.com/css2?family=Outfit:wght@500&display=swap"
        rel="stylesheet"
    />
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .database_update_section {
            min-height: 100vh;
            width: 100%;
            background: #eff4f8;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .database_update_section .info_container {
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            padding: 50px;
        }

        .update_info {
            text-align: center;
            font-family: Outfit;
            font-size: 32px;
            font-style: normal;
            font-weight: 500;
            line-height: normal;
            color: #0a2540;
        }

        .update_info.title {
            color: #fb1159;
        }

        .database_update_section .img_container {
            margin-bottom: 45px;
        }

        .reload_btn {
            background: #635bff;
            color: #fff;
            text-align: center;
            font-family: Outfit;
            font-size: 18px;
            font-style: normal;
            font-weight: 500;
            text-decoration: none;
            padding: 20px 25px;
            height: 64px;
            min-width: 180px;
            margin-top: 60px;
        }

        @media (max-width: 576px) {
            .update_info {
                font-size: 25px;
            }
        }

        @media (max-width: 480px) {
            .database_update_section .img_container svg {
                width: 200px;
                height: 200px;
            }

            .update_info {
                font-size: 20px;
            }

            .reload_btn {
                min-width: 150px;
                padding: 15px 20px;
                height: 54px;
                margin-top: 50px;
            }

            .database_update_section .img_container {
                margin-bottom: 40px;
            }
        }
        
    </style>
</head>
<body>
<div class="database_update_section">
    <div class="info_container">
        <div class="img_container">
            <svg
                width="257"
                height="257"
                viewBox="0 0 259 257"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
            >
                <path
                    d="M255.412 180.983C247.888 209.923 226.693 236.734 175.364 250.603C156.811 255.614 135.23 258.074 115.989 256.559C87.6642 254.32 57.9811 241.534 34.3907 227.032C18.0673 217 11.571 203.452 9.26791 188.152C7.84569 178.688 8.02003 168.546 8.47881 158.147C9.1578 142.497 6.67121 126.738 2.9918 111.52C-2.67871 88.0776 1.99166 63.4882 15.9753 43.3228C29.9497 23.1392 52.0445 9.11432 77.2407 4.39653C119.696 -3.54293 162.757 1.69803 162.757 1.69803C219.481 7.59067 248.191 63.9196 255.192 109.776C258.394 130.73 261.744 156.614 255.412 180.983Z"
                    fill="#F4F7FA"
                />
                <path
                    d="M27.2429 137.376C28.7936 136.293 31.0508 135.815 32.9226 135.843C46.2088 135.99 45.8693 163.764 43.3369 169.776C40.8044 175.779 41.9514 177.917 52.0904 182.002C62.2294 186.086 56.7241 191.896 55.1642 195.421C53.5952 198.955 50.8333 201.818 58.1188 206.05C65.4042 210.281 62.5873 212.31 62.5873 212.31C62.5873 212.31 47.4292 225.472 48.5761 220.956C49.7231 216.44 48.8973 209.409 36.4001 207.849C31.0141 207.179 22.9579 203.92 21.5999 197.991C21.2879 196.605 21.1595 194.531 21.5907 193.163C22.1963 191.263 23.591 189.85 24.4443 188.087C26.4354 183.984 22.5725 180.533 20.4346 177.504C19.3152 175.926 18.2049 174.301 17.3975 172.539C15.7183 168.877 16.7644 165.178 19.1684 162.121C20.3245 160.653 21.8843 159.129 22.4808 157.321C23.1231 155.375 22.9304 152.63 22.9854 150.584C23.0313 148.977 23.0038 147.371 23.224 145.774C23.6461 142.773 24.6462 139.184 27.2429 137.376Z"
                    fill="url(#paint0_linear_1_8)"
                />
                <mask
                    id="mask0_1_8"
                    style="mask-type: luminance"
                    maskUnits="userSpaceOnUse"
                    x="16"
                    y="135"
                    width="48"
                    height="87"
                >
                    <path
                        d="M27.2429 137.376C28.7936 136.293 31.0508 135.815 32.9226 135.843C46.2088 135.99 45.8693 163.764 43.3369 169.776C40.8044 175.779 41.9514 177.917 52.0904 182.002C62.2294 186.086 56.7241 191.896 55.1642 195.421C53.5952 198.955 50.8333 201.818 58.1188 206.05C65.4042 210.281 62.5873 212.31 62.5873 212.31C62.5873 212.31 47.4292 225.472 48.5761 220.956C49.7231 216.44 48.8973 209.409 36.4001 207.849C31.0141 207.179 22.9579 203.92 21.5999 197.991C21.2879 196.605 21.1595 194.531 21.5907 193.163C22.1963 191.263 23.591 189.85 24.4443 188.087C26.4354 183.984 22.5725 180.533 20.4346 177.504C19.3152 175.926 18.2049 174.301 17.3975 172.539C15.7183 168.877 16.7644 165.178 19.1684 162.121C20.3245 160.653 21.8843 159.129 22.4808 157.321C23.1231 155.375 22.9304 152.63 22.9854 150.584C23.0313 148.977 23.0038 147.371 23.224 145.774C23.6461 142.773 24.6462 139.184 27.2429 137.376Z"
                        fill="white"
                    />
                </mask>
                <g mask="url(#mask0_1_8)">
                    <g opacity="0.8">
                        <path
                            d="M63.0185 220.423C63.1103 220.46 63.2112 220.433 63.2663 220.35C63.3213 220.258 63.2938 220.139 63.202 220.084C63.147 220.047 57.5132 216.467 51.3655 210.823C45.7042 205.628 38.4279 197.56 35.9414 188.684C33.8677 181.268 32.4087 169.17 31.95 155.494C31.5371 143.232 32.0509 134.227 32.7849 132.612C32.8308 132.511 32.7849 132.401 32.684 132.355C32.5831 132.309 32.473 132.355 32.4271 132.456C31.5646 134.347 31.1792 144.48 31.5554 155.522C32.0142 169.225 33.4731 181.359 35.556 188.803C38.0701 197.771 45.3922 205.894 51.0994 211.125C57.2746 216.789 62.9268 220.387 62.991 220.423C63.0093 220.414 63.0185 220.414 63.0185 220.423Z"
                            fill="white"
                        />
                        <path
                            d="M31.7848 157.844C31.8857 157.89 31.9867 157.871 32.0326 157.77C32.0968 157.642 38.1068 144.792 44.6949 142.323C44.7958 142.286 44.8417 142.176 44.805 142.075C44.7683 141.974 44.649 141.928 44.5481 141.965C37.804 144.489 31.9133 157.064 31.6655 157.605C31.6288 157.706 31.6839 157.798 31.7848 157.844Z"
                            fill="white"
                        />
                        <path
                            d="M32.9226 173.411C32.996 173.447 33.0877 173.429 33.1428 173.365C33.2162 173.291 33.2162 173.163 33.1428 173.089C33.1061 173.053 29.7295 169.785 25.4628 166.921C19.7006 163.048 15.1403 161.726 11.9288 162.993C11.8279 163.03 11.782 163.149 11.8187 163.25C11.8554 163.351 11.9747 163.397 12.0756 163.36C19.4712 160.46 32.7482 173.246 32.8767 173.374C32.8859 173.392 32.9042 173.402 32.9226 173.411Z"
                            fill="white"
                        />
                        <path
                            d="M46.1263 206.123C46.1446 206.132 46.163 206.142 46.1905 206.142C46.3006 206.151 46.3923 206.077 46.4015 205.967C46.4107 205.912 46.9704 200.231 48.6587 194.338C50.2002 188.932 53.0171 182.241 57.6875 181.029C57.7884 181.001 57.8527 180.891 57.8251 180.79C57.7976 180.689 57.6875 180.625 57.5866 180.653C53.6961 181.662 50.5672 186.233 48.2825 194.237C46.5942 200.166 46.0253 205.875 46.0161 205.93C46.007 206.004 46.0529 206.086 46.1263 206.123Z"
                            fill="white"
                        />
                        <path
                            d="M38.8133 196.275C38.8867 196.311 38.9877 196.293 39.0427 196.229C39.1161 196.146 39.1069 196.027 39.0244 195.953C38.4371 195.439 24.4902 183.305 18.627 183.874C18.5169 183.883 18.4435 183.984 18.4527 184.085C18.4619 184.196 18.5628 184.269 18.6637 184.26C24.3709 183.709 38.6298 196.119 38.7674 196.247C38.7766 196.256 38.795 196.265 38.8133 196.275Z"
                            fill="white"
                        />
                    </g>
                </g>
                <path
                    d="M4.70764 157.926C5.94635 156.495 8.02003 155.485 9.84597 155.054C22.7652 151.97 29.1881 178.991 28.1972 185.435C27.2062 191.878 28.8303 193.668 39.6575 195.164C50.4847 196.66 46.5575 203.627 45.8969 207.436C45.2362 211.245 43.2543 214.696 51.3472 217.027C59.44 219.368 57.2012 222.011 57.2012 222.011C57.2012 222.011 45.7042 238.459 45.7225 233.797C45.7409 229.134 43.2268 222.516 30.7204 224.049C25.3344 224.71 16.7277 223.507 13.975 218.083C13.3327 216.816 12.6996 214.834 12.7913 213.402C12.9198 211.41 13.9291 209.694 14.3237 207.784C15.2596 203.315 10.6718 200.919 7.86404 198.496C6.39595 197.229 4.92785 195.935 3.7075 194.42C1.18421 191.272 1.3035 187.436 2.89087 183.883C3.65245 182.185 4.7994 180.322 4.93703 178.422C5.09302 176.375 4.23051 173.76 3.78091 171.759C3.43223 170.189 3.01933 168.638 2.845 167.032C2.5422 164.039 2.63396 160.313 4.70764 157.926Z"
                    fill="url(#paint1_linear_1_8)"
                />
                <mask
                    id="mask1_1_8"
                    style="mask-type: luminance"
                    maskUnits="userSpaceOnUse"
                    x="1"
                    y="154"
                    width="57"
                    height="81"
                >
                    <path
                        d="M4.70764 157.926C5.94635 156.495 8.02003 155.485 9.84597 155.054C22.7652 151.97 29.1881 178.991 28.1972 185.435C27.2062 191.878 28.8303 193.668 39.6575 195.164C50.4847 196.66 46.5575 203.627 45.8969 207.436C45.2362 211.245 43.2543 214.696 51.3472 217.027C59.44 219.368 57.2012 222.011 57.2012 222.011C57.2012 222.011 45.7042 238.459 45.7225 233.797C45.7409 229.134 43.2268 222.516 30.7204 224.049C25.3344 224.71 16.7277 223.507 13.975 218.083C13.3327 216.816 12.6996 214.834 12.7913 213.402C12.9198 211.41 13.9291 209.694 14.3237 207.784C15.2596 203.315 10.6718 200.919 7.86404 198.496C6.39595 197.229 4.92785 195.935 3.7075 194.42C1.18421 191.272 1.3035 187.436 2.89087 183.883C3.65245 182.185 4.7994 180.322 4.93703 178.422C5.09302 176.375 4.23051 173.76 3.78091 171.759C3.43223 170.189 3.01933 168.638 2.845 167.032C2.5422 164.039 2.63396 160.313 4.70764 157.926Z"
                        fill="white"
                    />
                </mask>
                <g mask="url(#mask1_1_8)">
                    <g opacity="0.8">
                        <path
                            d="M59.6144 229.776C59.7061 229.795 59.8071 229.74 59.8346 229.648C59.8713 229.547 59.8163 229.437 59.7061 229.4C59.6419 229.382 53.3108 227.28 45.9703 223.296C39.2079 219.634 30.1974 213.585 25.628 205.572C21.811 198.881 17.4617 187.5 13.6906 174.347C10.3048 162.552 8.61645 153.695 8.9376 151.942C8.95595 151.832 8.88254 151.731 8.78161 151.713C8.68068 151.694 8.57057 151.768 8.55222 151.869C8.17602 153.915 10.2681 163.837 13.3144 174.448C17.0947 187.628 21.4623 199.046 25.2885 205.756C29.9038 213.842 38.9877 219.946 45.7959 223.627C53.1639 227.619 59.5226 229.73 59.5869 229.749C59.596 229.776 59.6052 229.776 59.6144 229.776Z"
                            fill="white"
                        />
                        <path
                            d="M14.1493 176.311C14.2594 176.311 14.3237 176.476 14.3512 176.366C14.3787 176.229 17.0763 162.396 22.8661 158.395C22.9579 158.33 22.9671 158.266 22.912 158.174C22.8478 158.083 22.7285 158.092 22.6368 158.147C16.7093 162.24 14.0759 175.696 13.9658 176.274C13.9383 176.385 14.0392 176.311 14.1493 176.311Z"
                            fill="white"
                        />
                        <path
                            d="M18.9849 191.502C19.0674 191.52 19.15 191.483 19.1867 191.41C19.2418 191.318 19.2051 191.199 19.1133 191.144C19.0766 191.116 14.9935 188.766 10.1579 187.032C3.6341 184.673 -1.10968 184.498 -3.91741 186.509C-4.00917 186.573 -4.02752 186.692 -3.96329 186.784C-3.89906 186.876 -3.77978 186.894 -3.68802 186.83C2.78077 182.213 18.7647 191.392 18.9206 191.483C18.939 191.493 18.9665 191.502 18.9849 191.502Z"
                            fill="white"
                        />
                        <path
                            d="M39.7401 220.02C39.7584 220.02 39.7859 220.02 39.8043 220.02C39.9144 220.001 39.9878 219.9 39.9694 219.799C39.9603 219.744 39.1345 214.099 39.3272 207.977C39.5107 202.36 40.6117 195.182 44.8417 192.869C44.9334 192.814 44.9701 192.695 44.9243 192.603C44.8692 192.511 44.7499 192.475 44.6582 192.521C41.1347 194.448 39.2079 199.643 38.9326 207.959C38.7307 214.118 39.5657 219.79 39.5749 219.854C39.6024 219.937 39.6666 220.001 39.7401 220.02Z"
                            fill="white"
                        />
                        <path
                            d="M30.2525 212.245C30.3351 212.264 30.4177 212.218 30.4635 212.144C30.5094 212.053 30.4727 211.933 30.381 211.878C29.6836 211.52 13.2134 203.149 7.65301 205.123C7.55208 205.159 7.49703 205.27 7.53373 205.371C7.57043 205.472 7.68054 205.527 7.78147 205.49C13.1767 203.572 30.0231 212.135 30.1974 212.227C30.2158 212.236 30.2341 212.236 30.2525 212.245Z"
                            fill="white"
                        />
                    </g>
                </g>
                <path
                    d="M148.443 234.522L17.8654 233.384V236.752C17.8654 237.67 18.4343 238.441 19.2051 238.579L56.1277 245.206C56.5681 245.288 57.0085 245.306 57.4489 245.27L147.021 237.716C147.819 237.652 148.443 236.871 148.443 235.926V234.522Z"
                    fill="url(#paint2_linear_1_8)"
                />
                <path
                    d="M106.401 229.06L19.2968 235.219C17.737 235.329 16.4707 234.155 16.4707 232.603V170.308C16.4707 168.757 17.737 167.491 19.2968 167.491H106.401C107.685 167.491 108.722 168.629 108.722 170.033V226.344C108.731 227.757 107.685 228.969 106.401 229.06Z"
                    fill="url(#paint3_linear_1_8)"
                />
                <path
                    d="M107.795 229.06L20.6823 235.219C19.1225 235.329 17.8563 234.155 17.8563 232.603V170.308C17.8563 168.757 19.1225 167.491 20.6823 167.491H107.786C109.071 167.491 110.108 168.629 110.108 170.033V226.344C110.117 227.757 109.08 228.969 107.795 229.06Z"
                    fill="url(#paint4_linear_1_8)"
                />
                <path
                    d="M105.079 225.095L23.9489 230.446C22.6826 230.529 21.6458 229.565 21.6458 228.299V173.76C21.6458 172.493 22.6734 171.456 23.9489 171.456L105.079 171.116C106.135 171.116 106.997 172.043 106.997 173.2V222.874C106.997 224.031 106.144 225.022 105.079 225.095Z"
                    fill="white"
                />
                <path
                    d="M67.3127 169.207C67.3127 169.785 66.8631 170.253 66.3126 170.262C65.762 170.262 65.3124 169.794 65.3124 169.216C65.3124 168.638 65.762 168.17 66.3126 168.161C66.8723 168.151 67.3127 168.62 67.3127 169.207Z"
                    fill="white"
                />
                <path
                    d="M105.621 228.785L17.8654 235.265L56.1277 242.131C56.5681 242.213 57.0085 242.232 57.4489 242.195L148.443 234.522L107.015 228.831C106.557 228.767 106.089 228.748 105.621 228.785Z"
                    fill="url(#paint5_linear_1_8)"
                />
                <path
                    opacity="0.3"
                    d="M30.6654 235.43L103.731 229.951L126.339 233.035L53.9072 238.891L30.6654 235.43Z"
                    fill="url(#paint6_linear_1_8)"
                />
                <path
                    d="M107.006 181.662L21.6366 182.727V173.08C21.6366 171.997 22.5175 171.125 23.591 171.125H105.043C106.125 171.125 106.997 172.006 106.997 173.08V181.662H107.006Z"
                    fill="url(#paint7_linear_1_8)"
                />
                <path
                    d="M75.1578 207.5L26.8942 209.501V186.692L75.1578 185.884V207.5Z"
                    fill="url(#paint8_linear_1_8)"
                />
                <path
                    d="M102.62 206.371L78.0023 207.39V185.839L102.62 185.425V206.371Z"
                    fill="url(#paint9_linear_1_8)"
                />
                <path
                    d="M102.62 221.919L26.8942 226.426V212.475L102.62 209.106V221.919Z"
                    fill="url(#paint10_linear_1_8)"
                />
                <path
                    d="M27.7567 176.504C27.7567 177.101 27.2245 177.587 26.5731 177.596C25.9216 177.596 25.3894 177.119 25.3894 176.522C25.3894 175.926 25.9216 175.439 26.5731 175.43C27.2337 175.43 27.7567 175.907 27.7567 176.504Z"
                    fill="#9D3060"
                />
                <path
                    d="M32.0326 176.486C32.0326 177.082 31.5095 177.559 30.8581 177.569C30.2066 177.569 29.6836 177.091 29.6836 176.504C29.6836 175.907 30.2066 175.421 30.8581 175.421C31.5095 175.412 32.0326 175.889 32.0326 176.486Z"
                    fill="#9D3060"
                />
                <path
                    d="M36.2625 176.458C36.2625 177.045 35.7395 177.532 35.1064 177.532C34.4641 177.532 33.9411 177.064 33.9411 176.467C33.9411 175.871 34.4641 175.393 35.1064 175.393C35.7487 175.393 36.2625 175.871 36.2625 176.458Z"
                    fill="#9D3060"
                />
                <path
                    opacity="0.48"
                    d="M86.8108 211.979C80.0943 208.363 74.8183 212.943 69.7167 208.427C66.6245 205.692 68.1477 203.645 64.3398 199.551C60.1282 195.017 57.3847 196.541 53.1548 192.456C47.8054 187.298 50.4847 183.278 45.8693 179.579C40.2814 175.081 34.253 179.248 28.9312 174.934C26.6373 173.071 25.3802 170.373 24.7196 167.5H19.5079C18.5995 167.5 17.8563 168.243 17.8563 169.152V233.723C17.8563 234.632 18.5995 235.32 19.5079 235.256L108.282 228.95C108.713 228.923 109.108 228.666 109.355 228.299C102.859 228.06 98.8676 225.885 96.3076 223.627C91.3252 219.221 92.1877 214.88 86.8108 211.979Z"
                    fill="white"
                />
                <path
                    d="M201.506 233.273C199.487 232.603 197.973 230.887 197.551 228.785L194.615 214.237L169.474 215.127L166.382 230.281C165.95 232.401 167.685 234.531 169.685 235.32L180.2 239.441C182.154 240.203 184.256 240.515 186.348 240.332L208.58 238.432C209.232 238.377 209.755 237.863 209.828 237.211C209.901 236.559 210.36 235.816 209.736 235.614L201.506 233.273Z"
                    fill="#97A6B7"
                />
                <path
                    d="M201.753 232.392C199.735 231.731 198.23 230.043 197.808 227.959L194.872 213.595L170.345 214.476L167.253 229.446C166.822 231.539 167.969 233.641 169.96 234.421L180.466 238.487C182.421 239.239 184.522 239.542 186.614 239.368L208.819 237.486C209.47 237.431 209.984 236.926 210.067 236.284C210.14 235.632 209.755 235.026 209.131 234.825L201.753 232.392Z"
                    fill="url(#paint11_linear_1_8)"
                />
                <path
                    d="M241.897 204.113V138.872C241.897 137.532 240.796 136.394 239.447 136.339L127.395 131.841C125.688 131.777 124.293 132.952 124.293 134.457V206.564L241.897 204.113Z"
                    fill="url(#paint12_linear_1_8)"
                />
                <path
                    d="M127.752 144.489V200.809C127.752 202.213 129.055 203.324 130.633 203.287L236.979 200.258C238.245 200.221 239.282 199.166 239.282 197.908V147.683L127.752 144.489Z"
                    fill="white"
                />
                <path
                    d="M239.282 147.683V141.919C239.282 140.689 238.263 139.652 237.024 139.606L130.569 135.632C129.019 135.577 127.743 136.651 127.743 138.027V144.489L239.282 147.683Z"
                    fill="url(#paint13_linear_1_8)"
                />
                <path
                    d="M135.533 140.102C135.533 140.588 135.093 140.965 134.551 140.946C134.01 140.928 133.56 140.524 133.56 140.037C133.56 139.551 134.001 139.175 134.551 139.193C135.093 139.211 135.533 139.624 135.533 140.102Z"
                    fill="#9D3060"
                />
                <path
                    d="M139.782 140.249C139.782 140.726 139.35 141.102 138.809 141.093C138.268 141.075 137.836 140.671 137.836 140.184C137.836 139.698 138.277 139.322 138.809 139.34C139.35 139.358 139.782 139.762 139.782 140.249Z"
                    fill="#9D3060"
                />
                <path
                    d="M143.984 140.386C143.984 140.864 143.553 141.24 143.021 141.222C142.488 141.203 142.057 140.799 142.057 140.322C142.057 139.845 142.488 139.468 143.021 139.487C143.553 139.505 143.984 139.909 143.984 140.386Z"
                    fill="#9D3060"
                />
                <path
                    d="M124.284 206.564V220.965C124.284 222.47 125.688 223.654 127.385 223.581L239.438 218.845C240.786 218.79 241.888 217.642 241.888 216.311V203.709L124.284 206.564Z"
                    fill="url(#paint14_linear_1_8)"
                />
                <path
                    d="M197.707 176.054L135.919 176.394V150.584L197.707 151.713V176.054Z"
                    fill="url(#paint15_linear_1_8)"
                />
                <path
                    d="M232.602 175.871L201.331 176.036V151.777L232.602 152.346V175.871Z"
                    fill="url(#paint16_linear_1_8)"
                />
                <path
                    d="M232.602 193.328L135.919 195.549V179.762L232.602 178.936V193.328Z"
                    fill="url(#paint17_linear_1_8)"
                />
                <g opacity="0.48">
                    <path
                        d="M229.757 195.696C220.554 192.585 212.939 198.927 206.323 193.934C198.863 188.308 204.892 177.486 197.991 171.116C188.412 162.268 169.244 175.99 160.931 167.647C155.206 161.91 161.959 152.722 157.114 143.057C154.655 138.147 150.04 134.797 144.434 132.52L127.385 131.832C125.679 131.768 124.284 132.942 124.284 134.448V206.555V220.956C124.284 222.461 125.679 223.645 127.385 223.572L239.438 218.835C240.786 218.78 241.888 217.633 241.888 216.302V206.995C237.951 200.01 233.593 196.991 229.757 195.696Z"
                        fill="white"
                    />
                </g>
                <path
                    d="M69.8727 114.851C76.892 115.209 82.7094 121.772 83.003 129.51C83.0305 130.244 83.0121 130.969 82.9387 131.667C84.1224 131.134 85.4161 130.85 86.7925 130.886C92.2978 131.033 96.8765 136.21 97.115 142.451C97.3352 148.372 93.5641 153.255 88.4716 153.769C88.2055 153.796 87.9303 153.814 87.655 153.814L38.1251 154.071C35.0972 153.512 32.7024 150.74 32.5647 147.389C32.4088 143.608 35.1981 140.57 38.7491 140.616C39.4923 140.625 40.2172 140.763 40.8962 141.029C40.5934 139.872 40.4007 138.661 40.3548 137.422C40.0061 128.895 46.1813 122.222 53.9714 122.525C55.4028 122.58 56.7791 122.864 58.0821 123.351C59.8346 118.101 64.4224 114.576 69.8727 114.851Z"
                    fill="#413974"
                />
                <path
                    d="M73.0933 112.254C80.0484 112.639 85.8107 119.193 86.0951 126.885C86.1227 127.619 86.1043 128.335 86.0309 129.032C87.1962 128.509 88.49 128.234 89.848 128.28C95.2983 128.454 99.8402 133.622 100.07 139.826C100.29 145.719 96.5461 150.565 91.5087 151.052C91.2427 151.079 90.9766 151.088 90.7013 151.098L41.6669 151.144C38.6757 150.574 36.2992 147.812 36.1616 144.471C36.0056 140.707 38.7674 137.697 42.2817 137.752C43.0249 137.761 43.7406 137.908 44.4013 138.165C44.0985 137.009 43.9149 135.806 43.8599 134.576C43.5204 126.095 49.6313 119.477 57.3388 119.817C58.7519 119.881 60.119 120.175 61.4128 120.652C63.1562 115.439 67.6981 111.951 73.0933 112.254Z"
                    fill="url(#paint18_linear_1_8)"
                />
                <path
                    d="M114.787 108.674C114.081 108.674 113.512 108.105 113.512 107.398V103.406C113.512 102.699 114.081 102.13 114.787 102.13C115.494 102.13 116.063 102.699 116.063 103.406V107.398C116.063 108.105 115.494 108.674 114.787 108.674Z"
                    fill="#413974"
                />
                <path
                    d="M114.787 183.278C114.081 183.278 113.512 182.709 113.512 182.002V174.54C113.512 173.833 114.081 173.264 114.787 173.264C115.494 173.264 116.063 173.833 116.063 174.54V182.002C116.063 182.699 115.494 183.278 114.787 183.278ZM114.787 168.353C114.081 168.353 113.512 167.784 113.512 167.078V159.615C113.512 158.909 114.081 158.34 114.787 158.34C115.494 158.34 116.063 158.909 116.063 159.615V167.078C116.063 167.784 115.494 168.353 114.787 168.353ZM114.787 153.438C114.081 153.438 113.512 152.869 113.512 152.162V144.7C113.512 143.993 114.081 143.424 114.787 143.424C115.494 143.424 116.063 143.993 116.063 144.7V152.162C116.063 152.86 115.494 153.438 114.787 153.438ZM114.787 138.514C114.081 138.514 113.512 137.945 113.512 137.238V129.776C113.512 129.069 114.081 128.5 114.787 128.5C115.494 128.5 116.063 129.069 116.063 129.776V137.238C116.063 137.945 115.494 138.514 114.787 138.514ZM114.787 123.599C114.081 123.599 113.512 123.03 113.512 122.323V114.861C113.512 114.154 114.081 113.585 114.787 113.585C115.494 113.585 116.063 114.154 116.063 114.861V122.323C116.063 123.03 115.494 123.599 114.787 123.599Z"
                    fill="#413974"
                />
                <path
                    d="M116.063 194.751L108.722 194.604C108.016 194.586 107.456 194.007 107.474 193.301C107.493 192.594 108.062 192.034 108.777 192.052L113.512 192.144V189.455C113.512 188.748 114.081 188.179 114.787 188.179C115.494 188.179 116.063 188.748 116.063 189.455V194.751Z"
                    fill="#413974"
                />
                <path
                    d="M168.281 112.18C167.574 112.18 167.006 111.611 167.006 110.905V106.912C167.006 106.205 167.574 105.636 168.281 105.636C168.987 105.636 169.556 106.205 169.556 106.912V110.905C169.556 111.611 168.987 112.18 168.281 112.18Z"
                    fill="#413974"
                />
                <path
                    d="M168.281 125.462C167.574 125.462 167.006 124.893 167.006 124.186V117.541C167.006 116.834 167.574 116.265 168.281 116.265C168.987 116.265 169.556 116.834 169.556 117.541V124.186C169.556 124.893 168.987 125.462 168.281 125.462Z"
                    fill="#413974"
                />
                <path
                    d="M168.281 136.1C167.574 136.1 167.006 135.531 167.006 134.824V130.831C167.006 130.125 167.574 129.556 168.281 129.556C168.987 129.556 169.556 130.125 169.556 130.831V134.824C169.556 135.522 168.987 136.1 168.281 136.1Z"
                    fill="#413974"
                />
                <path
                    d="M201.331 116.852C200.625 116.852 200.056 116.283 200.056 115.577V111.584C200.056 110.877 200.625 110.308 201.331 110.308C202.038 110.308 202.607 110.877 202.607 111.584V115.577C202.607 116.274 202.038 116.852 201.331 116.852Z"
                    fill="#413974"
                />
                <path
                    d="M201.331 127.6C200.625 127.6 200.056 127.031 200.056 126.325V120.946C200.056 120.239 200.625 119.67 201.331 119.67C202.038 119.67 202.607 120.239 202.607 120.946V126.325C202.607 127.031 202.038 127.6 201.331 127.6Z"
                    fill="#413974"
                />
                <path
                    d="M201.331 136.972C200.625 136.972 200.056 136.403 200.056 135.696V131.703C200.056 130.997 200.625 130.427 201.331 130.427C202.038 130.427 202.607 130.997 202.607 131.703V135.696C202.607 136.403 202.038 136.972 201.331 136.972Z"
                    fill="#413974"
                />
                <path
                    d="M78.0023 147.16C77.2957 147.16 76.7269 146.591 76.7269 145.884V141.892C76.7269 141.185 77.2957 140.616 78.0023 140.616C78.7088 140.616 79.2777 141.185 79.2777 141.892V145.884C79.2868 146.582 78.7088 147.16 78.0023 147.16Z"
                    fill="#413974"
                />
                <path
                    d="M78.0023 157.908C77.2957 157.908 76.7269 157.339 76.7269 156.632V151.254C76.7269 150.547 77.2957 149.978 78.0023 149.978C78.7088 149.978 79.2777 150.547 79.2777 151.254V156.632C79.2868 157.339 78.7088 157.908 78.0023 157.908Z"
                    fill="#413974"
                />
                <path
                    d="M78.0023 167.279C77.2957 167.279 76.7269 166.71 76.7269 166.004V162.011C76.7269 161.304 77.2957 160.735 78.0023 160.735C78.7088 160.735 79.2777 161.304 79.2777 162.011V166.004C79.2868 166.71 78.7088 167.279 78.0023 167.279Z"
                    fill="#413974"
                />
                <path
                    d="M205.286 96.6412C203.616 101.01 200.9 104.737 197.441 107.499C193.661 110.528 188.99 112.382 183.834 112.649C183.118 112.676 182.384 112.685 181.65 112.658L56.6874 107.61C49.4937 105.967 43.814 99.1653 43.4929 91.2442C43.2084 84.1767 47.2732 78.3391 53.1731 76.3932C54.7238 75.8792 56.4121 75.6406 58.183 75.714C59.9814 75.7875 61.7064 76.1821 63.3305 76.8522C62.9635 75.4754 62.6699 74.0802 62.4496 72.6576C62.2294 71.2074 62.0826 69.7296 62.0184 68.2335C61.422 53.6212 68.9827 41.3954 80.3787 36.0442C84.8197 33.9607 89.8296 32.9235 95.179 33.1897C95.2157 33.1897 95.2524 33.1897 95.2799 33.1989C98.7758 33.3825 102.171 34.1167 105.391 35.31C105.878 33.9148 106.437 32.5564 107.089 31.2714C110.181 25.1217 115.09 20.2755 121.128 17.4668C125.348 15.5026 130.11 14.5297 135.185 14.7959C153.306 15.7504 168.538 32.1617 169.309 51.4642C169.382 53.3 169.327 55.099 169.134 56.8521C172.254 55.5854 175.695 54.9613 179.338 55.1265C194.083 55.8057 206.497 69.1881 207.121 85.0119C207.314 89.179 206.635 93.1166 205.286 96.6412Z"
                    fill="#413974"
                />
                <path
                    d="M208.36 97.3938C205.791 101.864 202.001 105.388 197.441 107.49C194.771 108.72 191.835 109.464 188.724 109.62C188.008 109.656 187.284 109.666 186.55 109.629L61.7982 104.526C54.6137 102.873 48.9432 96.0905 48.622 88.1694C48.4293 83.4149 50.2094 79.2203 53.1915 76.3933C55.623 74.0894 58.8528 72.6943 62.468 72.6484C62.7433 72.6392 63.0185 72.6484 63.2938 72.6576C65.083 72.731 66.808 73.1257 68.4321 73.7957C67.6981 71.0238 67.2485 68.1325 67.1292 65.1862C66.6245 52.8778 71.9097 42.2673 80.4063 36.0443C84.8381 32.7859 90.1324 30.739 95.9497 30.2618C97.3536 30.1424 98.785 30.1149 100.244 30.1883C102.593 30.3076 104.896 30.6748 107.126 31.2622C108.245 31.5559 109.355 31.9047 110.438 32.3086C112.539 26.2048 116.292 21.0648 121.164 17.4576C126.431 13.5567 133.001 11.4457 140.185 11.822C158.28 12.7857 173.483 29.197 174.254 48.472C174.328 50.3077 174.273 52.1068 174.08 53.8507C177.19 52.584 180.631 51.9599 184.265 52.1343C198.982 52.8227 211.379 66.1959 212.003 82.0105C212.223 87.738 210.874 93.0248 208.36 97.3938Z"
                    fill="url(#paint19_linear_1_8)"
                />
                <path
                    d="M113.31 63.9838L109.566 70.4731L103.189 67.0678L104.309 71.2624L110.686 74.6585L114.429 68.1784L113.31 63.9838Z"
                    fill="white"
                />
                <path
                    d="M156.123 53.9975L151.214 52.015C149.81 50.1792 148.076 48.5638 146.048 47.2421C136.001 40.7161 122.063 43.7451 114.98 53.9975C112.035 58.2564 110.64 63.1761 110.933 68.105C110.989 69.0687 111.108 70.0233 111.291 70.9779C111.447 71.7948 110.897 72.6208 110.062 72.8136C109.227 73.0063 108.419 72.5015 108.254 71.6846C108.117 70.9871 108.016 70.2987 107.942 69.6011C107.3 63.5983 108.869 57.5405 112.457 52.3546C120.522 40.6794 136.387 37.2283 147.819 44.6629C149.242 45.5808 150.526 46.6363 151.691 47.7928C153.517 49.6285 155.004 51.7212 156.123 53.9975Z"
                    fill="white"
                />
                <path
                    d="M153.811 70.0784L157.555 63.5983L163.932 66.9944L162.812 62.7998L156.435 59.4037L152.692 65.8838L153.811 70.0784Z"
                    fill="white"
                />
                <path
                    d="M154.664 81.7076C146.599 93.3828 130.734 96.8247 119.292 89.3993C117.87 88.4814 116.586 87.4259 115.42 86.2694C113.64 84.4887 112.181 82.4511 111.071 80.2391L116.274 82.5245C117.613 84.1675 119.219 85.6269 121.072 86.8293C131.12 93.3552 145.048 90.3263 152.141 80.0738C155.086 75.815 156.481 70.8953 156.187 65.9664C156.132 65.0026 156.013 64.0481 155.83 63.0935C155.674 62.2766 156.224 61.4505 157.059 61.2578C157.894 61.065 158.702 61.5698 158.867 62.3867C159.004 63.0843 159.105 63.7727 159.179 64.4703C159.821 70.4639 158.252 76.5126 154.664 81.7076Z"
                    fill="white"
                />
                <path
                    opacity="0.2"
                    d="M208.36 97.3938C205.791 101.864 202.001 105.388 197.441 107.49C193.661 110.519 188.99 112.373 183.834 112.639C183.118 112.667 182.384 112.676 181.65 112.649L56.6874 107.6C49.4937 105.957 43.814 99.1561 43.4929 91.235C43.2084 84.1675 47.2732 78.3299 53.1731 76.3841C55.6046 74.0802 58.8345 72.6851 62.4496 72.6392C62.2294 71.189 62.0826 69.7113 62.0184 68.2151C61.422 53.6029 68.9827 41.377 80.3787 36.0259C84.8106 32.7675 90.1049 30.7207 95.9222 30.2434C95.702 31.1062 95.4818 32.0975 95.2891 33.1805C93.8485 41.3219 94.0412 54.8144 108.318 61.9186C109.218 62.3684 110.172 62.7906 111.19 63.1853C112.677 63.7635 114.301 64.2867 116.053 64.7273C125.972 67.2606 141.488 57.5129 155.114 61.6708C155.417 61.7626 155.729 61.9829 156.032 61.9829C157.041 62.3041 158.032 62.7722 159.014 63.2954C160.684 64.1949 162.317 65.3606 163.895 66.8475C166.538 69.3349 169.015 72.7218 171.263 77.256C180.237 95.3929 194.11 94.319 205.286 96.632C206.341 96.8523 207.369 97.1001 208.36 97.3938Z"
                    fill="url(#paint20_linear_1_8)"
                />
                <path
                    d="M214.856 88.4631C221.242 88.7935 226.647 94.5209 226.922 101.24C226.95 101.882 226.922 102.506 226.858 103.112C227.968 102.681 229.189 102.47 230.491 102.534C235.767 102.809 240.218 107.527 240.447 113.071C240.658 118.339 236.979 122.46 232.088 122.626C231.831 122.635 231.574 122.635 231.308 122.617L187.614 120.175C185.155 119.578 183.21 117.229 183.1 114.521C182.971 111.474 185.228 109.124 188.119 109.28C188.733 109.317 189.33 109.454 189.88 109.684C189.623 108.729 189.477 107.738 189.431 106.728C189.146 99.7802 194.266 94.4291 200.873 94.7779C202.102 94.8422 203.295 95.0992 204.424 95.5214C205.956 91.1432 209.993 88.2061 214.856 88.4631Z"
                    fill="#413974"
                />
                <path
                    d="M217.627 86.1868C224.013 86.5172 229.418 92.2446 229.693 98.9633C229.721 99.6058 229.693 100.23 229.629 100.836C230.739 100.404 231.96 100.193 233.262 100.258C238.538 100.533 242.989 105.251 243.218 110.795C243.429 116.063 239.75 120.184 234.859 120.349C234.602 120.359 234.345 120.359 234.079 120.34L190.385 117.899C187.926 117.302 185.981 114.952 185.871 112.245C185.742 109.197 187.999 106.848 190.89 107.004C191.504 107.04 192.101 107.178 192.651 107.408C192.394 106.453 192.248 105.462 192.202 104.452C191.917 97.504 197.037 92.1528 203.644 92.5016C204.873 92.5659 206.066 92.8229 207.195 93.2451C208.727 88.8761 212.764 85.939 217.627 86.1868Z"
                    fill="url(#paint21_linear_1_8)"
                />
                <mask
                    id="mask2_1_8"
                    style="mask-type: luminance"
                    maskUnits="userSpaceOnUse"
                    x="197"
                    y="169"
                    width="58"
                    height="72"
                >
                    <path
                        d="M197.78 227.601C197.78 227.601 198.212 230.915 200.79 232.062C203.956 233.475 209.672 234.246 210.048 235.898C210.424 237.551 211.562 237.982 211.562 237.982L227.766 240.497L252.027 216.651L254.743 180.671L236.07 177.706V169.923H211.168V204.728L197.854 213.585L197.78 227.601Z"
                        fill="white"
                    />
                </mask>
                <g mask="url(#mask2_1_8)">
                    <path
                        d="M226.803 171.309C225.482 170.382 223.555 169.978 221.958 169.996C210.645 170.125 210.929 193.787 213.085 198.9C215.242 204.012 214.269 205.839 205.635 209.317C197.001 212.796 201.689 217.743 203.02 220.754C204.35 223.764 206.708 226.206 200.496 229.813C194.294 233.42 196.689 235.146 196.689 235.146C196.689 235.146 209.599 246.353 208.626 242.507C207.644 238.661 208.36 232.668 219.004 231.346C223.591 230.777 230.455 228.005 231.611 222.947C231.877 221.773 231.987 220.001 231.611 218.835C231.088 217.22 229.904 216.009 229.179 214.512C227.482 211.015 230.776 208.078 232.593 205.499C233.547 204.15 234.492 202.773 235.18 201.268C236.612 198.147 235.722 194.999 233.666 192.392C232.684 191.144 231.354 189.84 230.84 188.298C230.29 186.637 230.455 184.306 230.418 182.553C230.381 181.185 230.4 179.817 230.216 178.45C229.858 175.916 229.014 172.851 226.803 171.309Z"
                        fill="url(#paint22_linear_1_8)"
                    />
                    <mask
                        id="mask3_1_8"
                        style="mask-type: luminance"
                        maskUnits="userSpaceOnUse"
                        x="196"
                        y="169"
                        width="40"
                        height="75"
                    >
                        <path
                            d="M226.803 171.309C225.482 170.382 223.555 169.978 221.958 169.996C210.645 170.125 210.929 193.787 213.085 198.9C215.242 204.012 214.269 205.839 205.635 209.317C197.001 212.796 201.689 217.743 203.02 220.754C204.35 223.764 206.708 226.206 200.496 229.813C194.294 233.42 196.689 235.146 196.689 235.146C196.689 235.146 209.599 246.353 208.626 242.507C207.644 238.661 208.36 232.668 219.004 231.346C223.591 230.777 230.455 228.005 231.611 222.947C231.877 221.773 231.987 220.001 231.611 218.835C231.088 217.22 229.904 216.009 229.179 214.512C227.482 211.015 230.776 208.078 232.593 205.499C233.547 204.15 234.492 202.773 235.18 201.268C236.612 198.147 235.722 194.999 233.666 192.392C232.684 191.144 231.354 189.84 230.84 188.298C230.29 186.637 230.455 184.306 230.418 182.553C230.381 181.185 230.4 179.817 230.216 178.45C229.858 175.916 229.014 172.851 226.803 171.309Z"
                            fill="white"
                        />
                    </mask>
                    <g mask="url(#mask3_1_8)">
                        <g opacity="0.8">
                            <path
                                d="M196.322 242.066C196.248 242.103 196.156 242.076 196.11 242.002C196.065 241.929 196.083 241.819 196.166 241.773C196.211 241.745 201.01 238.689 206.25 233.888C211.076 229.464 217.269 222.59 219.389 215.026C221.16 208.712 222.399 198.404 222.784 186.747C223.133 176.302 222.701 168.629 222.068 167.252C222.032 167.169 222.068 167.068 222.151 167.032C222.233 166.995 222.334 167.032 222.371 167.114C223.105 168.73 223.435 177.358 223.114 186.756C222.72 198.432 221.481 208.767 219.701 215.109C217.563 222.755 211.324 229.666 206.461 234.127C201.203 238.955 196.377 242.021 196.331 242.048C196.331 242.057 196.322 242.057 196.322 242.066Z"
                                fill="white"
                            />
                            <path
                                d="M222.931 188.757C222.848 188.794 222.756 188.776 222.72 188.693C222.665 188.583 217.545 177.642 211.929 175.531C211.847 175.494 211.801 175.412 211.837 175.32C211.874 175.237 211.966 175.191 212.058 175.228C217.802 177.376 222.821 188.096 223.032 188.546C223.059 188.638 223.013 188.721 222.931 188.757Z"
                                fill="white"
                            />
                            <path
                                d="M221.958 202.011C221.894 202.039 221.821 202.03 221.765 201.974C221.701 201.91 221.701 201.8 221.765 201.736C221.793 201.708 224.674 198.918 228.308 196.476C233.217 193.181 237.098 192.052 239.841 193.126C239.924 193.163 239.97 193.255 239.933 193.347C239.896 193.429 239.805 193.475 239.713 193.438C233.409 190.969 222.105 201.864 221.995 201.974C221.995 201.993 221.977 202.011 221.958 202.011Z"
                                fill="white"
                            />
                            <path
                                d="M210.709 229.877C210.691 229.887 210.672 229.886 210.654 229.896C210.562 229.905 210.479 229.841 210.47 229.749C210.461 229.703 209.984 224.866 208.553 219.845C207.24 215.247 204.836 209.538 200.863 208.51C200.772 208.482 200.717 208.399 200.744 208.308C200.772 208.216 200.854 208.161 200.946 208.188C204.258 209.051 206.929 212.943 208.874 219.763C210.314 224.811 210.801 229.675 210.801 229.721C210.819 229.786 210.773 229.85 210.709 229.877Z"
                                fill="white"
                            />
                            <path
                                d="M216.948 221.488C216.884 221.516 216.801 221.506 216.756 221.442C216.691 221.369 216.701 221.268 216.774 221.204C217.279 220.763 229.152 210.428 234.152 210.914C234.244 210.924 234.308 211.006 234.299 211.098C234.29 211.19 234.208 211.254 234.116 211.245C229.253 210.777 217.113 221.35 216.985 221.451C216.976 221.47 216.957 221.479 216.948 221.488Z"
                                fill="white"
                            />
                        </g>
                    </g>
                    <path
                        d="M251.815 183.645C250.999 182.259 249.411 181.093 247.953 180.451C237.602 175.88 228.06 197.532 227.904 203.085C227.748 208.638 226.105 209.886 216.811 209.473C207.507 209.06 209.727 215.504 209.7 218.799C209.672 222.094 210.801 225.288 203.653 225.995C196.505 226.711 197.982 229.272 197.982 229.272C197.982 229.272 205.093 244.829 205.8 240.919C206.506 237.009 209.626 231.851 219.866 235.054C224.28 236.431 231.675 236.752 234.822 232.631C235.556 231.667 236.391 230.098 236.529 228.886C236.722 227.197 236.144 225.609 236.107 223.939C236.015 220.056 240.227 218.744 242.952 217.147C244.374 216.311 245.805 215.449 247.063 214.366C249.659 212.117 250.155 208.877 249.366 205.664C248.989 204.122 248.31 202.387 248.485 200.772C248.668 199.037 249.797 196.981 250.476 195.366C251.008 194.108 251.595 192.869 251.99 191.548C252.696 189.097 253.192 185.958 251.815 183.645Z"
                        fill="url(#paint23_linear_1_8)"
                    />
                    <mask
                        id="mask4_1_8"
                        style="mask-type: luminance"
                        maskUnits="userSpaceOnUse"
                        x="197"
                        y="179"
                        width="56"
                        height="63"
                    >
                        <path
                            d="M251.815 183.645C250.999 182.259 249.411 181.093 247.953 180.451C237.602 175.88 228.06 197.532 227.904 203.085C227.748 208.638 226.105 209.886 216.811 209.473C207.507 209.06 209.727 215.504 209.7 218.799C209.672 222.094 210.801 225.288 203.653 225.995C196.505 226.711 197.982 229.272 197.982 229.272C197.982 229.272 205.093 244.829 205.8 240.919C206.506 237.009 209.626 231.851 219.866 235.054C224.28 236.431 231.675 236.752 234.822 232.631C235.556 231.667 236.391 230.098 236.529 228.886C236.722 227.197 236.144 225.609 236.107 223.939C236.015 220.056 240.227 218.744 242.952 217.147C244.374 216.311 245.805 215.449 247.063 214.366C249.659 212.117 250.155 208.877 249.366 205.664C248.989 204.122 248.31 202.387 248.485 200.772C248.668 199.037 249.797 196.981 250.476 195.366C251.008 194.108 251.595 192.869 251.99 191.548C252.696 189.097 253.192 185.958 251.815 183.645Z"
                            fill="white"
                        />
                    </mask>
                    <g mask="url(#mask4_1_8)">
                        <g opacity="0.8">
                            <path
                                d="M194.771 235.403C194.688 235.403 194.615 235.339 194.606 235.256C194.597 235.164 194.661 235.082 194.753 235.072C194.808 235.063 200.441 234.274 207.195 232.071C213.425 230.043 221.903 226.362 226.968 220.35C231.189 215.329 236.593 206.463 241.768 196.027C246.411 186.665 249.191 179.505 249.191 177.982C249.191 177.89 249.265 177.816 249.356 177.816C249.448 177.816 249.522 177.89 249.522 177.982C249.522 179.753 246.246 187.748 242.062 196.174C236.868 206.637 231.455 215.531 227.216 220.57C222.105 226.637 213.553 230.355 207.286 232.392C200.506 234.604 194.844 235.394 194.789 235.403C194.789 235.403 194.78 235.403 194.771 235.403Z"
                                fill="white"
                            />
                            <path
                                d="M241.071 197.706C240.979 197.706 240.906 197.762 240.906 197.67C240.906 197.55 240.777 185.517 236.538 181.277C236.474 181.213 236.474 181.139 236.538 181.075C236.602 181.011 236.713 181.029 236.777 181.093C241.117 185.435 241.245 197.165 241.245 197.67C241.236 197.743 241.163 197.706 241.071 197.706Z"
                                fill="white"
                            />
                            <path
                                d="M234.694 209.574C234.63 209.574 234.565 209.528 234.538 209.464C234.51 209.382 234.556 209.281 234.639 209.253C234.676 209.244 238.456 207.895 242.768 207.179C248.604 206.215 252.605 206.793 254.651 208.913C254.715 208.978 254.715 209.088 254.651 209.152C254.587 209.216 254.476 209.216 254.412 209.152C249.696 204.287 234.896 209.519 234.749 209.574C234.731 209.574 234.712 209.574 234.694 209.574Z"
                                fill="white"
                            />
                            <path
                                d="M212.92 230.281C212.902 230.281 212.883 230.281 212.865 230.272C212.773 230.244 212.727 230.144 212.764 230.061C212.783 230.015 214.342 225.417 215.122 220.249C215.829 215.513 216.012 209.327 212.819 206.747C212.746 206.692 212.737 206.582 212.792 206.509C212.847 206.435 212.957 206.426 213.03 206.481C215.691 208.638 216.508 213.292 215.453 220.304C214.673 225.499 213.104 230.125 213.085 230.171C213.049 230.235 212.984 230.281 212.92 230.281Z"
                                fill="white"
                            />
                            <path
                                d="M222.068 225.224C221.995 225.224 221.931 225.178 221.912 225.104C221.885 225.013 221.94 224.921 222.022 224.893C222.665 224.701 237.749 220.221 242.099 222.727C242.181 222.773 242.209 222.874 242.163 222.957C242.117 223.039 242.016 223.067 241.933 223.021C237.703 220.579 222.27 225.169 222.114 225.215C222.096 225.224 222.077 225.224 222.068 225.224Z"
                                fill="white"
                            />
                        </g>
                    </g>
                </g>
                <defs>
                    <linearGradient
                        id="paint0_linear_1_8"
                        x1="43.9"
                        y1="130.899"
                        x2="32.4357"
                        y2="297.712"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FFC444"/>
                        <stop offset="0.9964" stop-color="#F36F56"/>
                    </linearGradient>
                    <linearGradient
                        id="paint1_linear_1_8"
                        x1="1.75373"
                        y1="194.721"
                        x2="57.4936"
                        y2="194.721"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FF9085"/>
                        <stop offset="1" stop-color="#FB6FBB"/>
                    </linearGradient>
                    <linearGradient
                        id="paint2_linear_1_8"
                        x1="73.017"
                        y1="239.541"
                        x2="63.8432"
                        y2="243.393"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#40447E"/>
                        <stop offset="0.9964" stop-color="#3C3B6B"/>
                    </linearGradient>
                    <linearGradient
                        id="paint3_linear_1_8"
                        x1="60.7683"
                        y1="199.1"
                        x2="50.8123"
                        y2="203.28"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#40447E"/>
                        <stop offset="0.9964" stop-color="#3C3B6B"/>
                    </linearGradient>
                    <linearGradient
                        id="paint4_linear_1_8"
                        x1="17.8606"
                        y1="201.364"
                        x2="110.116"
                        y2="201.364"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#40447E"/>
                        <stop offset="0.9964" stop-color="#3C3B6B"/>
                    </linearGradient>
                    <linearGradient
                        id="paint5_linear_1_8"
                        x1="17.8606"
                        y1="235.491"
                        x2="148.44"
                        y2="235.491"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#40447E"/>
                        <stop offset="0.9964" stop-color="#3C3B6B"/>
                    </linearGradient>
                    <linearGradient
                        id="paint6_linear_1_8"
                        x1="30.6661"
                        y1="234.42"
                        x2="126.341"
                        y2="234.42"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#40447E"/>
                        <stop offset="0.9964" stop-color="#3C3B6B"/>
                    </linearGradient>
                    <linearGradient
                        id="paint7_linear_1_8"
                        x1="53.6391"
                        y1="193.933"
                        x2="85.8128"
                        y2="143.222"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FF9085"/>
                        <stop offset="1" stop-color="#FB6FBB"/>
                    </linearGradient>
                    <linearGradient
                        id="paint8_linear_1_8"
                        x1="46.3021"
                        y1="187.446"
                        x2="73.1408"
                        y2="245.601"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint9_linear_1_8"
                        x1="79.1728"
                        y1="172.248"
                        x2="104.84"
                        y2="227.865"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint10_linear_1_8"
                        x1="51.1785"
                        y1="188.322"
                        x2="75.7372"
                        y2="241.538"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint11_linear_1_8"
                        x1="188.242"
                        y1="219.409"
                        x2="188.624"
                        y2="233.745"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#444B8C"/>
                        <stop offset="0.9964" stop-color="#26264F"/>
                    </linearGradient>
                    <linearGradient
                        id="paint12_linear_1_8"
                        x1="191.362"
                        y1="201.588"
                        x2="149.225"
                        y2="53.7033"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#444B8C"/>
                        <stop offset="0.9964" stop-color="#26264F"/>
                    </linearGradient>
                    <linearGradient
                        id="paint13_linear_1_8"
                        x1="149.245"
                        y1="105.949"
                        x2="226.018"
                        y2="188.349"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FF9085"/>
                        <stop offset="1" stop-color="#FB6FBB"/>
                    </linearGradient>
                    <linearGradient
                        id="paint14_linear_1_8"
                        x1="124.288"
                        y1="213.637"
                        x2="241.898"
                        y2="213.637"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#444B8C"/>
                        <stop offset="0.9964" stop-color="#26264F"/>
                    </linearGradient>
                    <linearGradient
                        id="paint15_linear_1_8"
                        x1="160.897"
                        y1="151.223"
                        x2="194.527"
                        y2="224.095"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint16_linear_1_8"
                        x1="203.507"
                        y1="135.01"
                        x2="234.509"
                        y2="202.187"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint17_linear_1_8"
                        x1="166.475"
                        y1="148.687"
                        x2="198.668"
                        y2="218.444"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint18_linear_1_8"
                        x1="36.1555"
                        y1="131.694"
                        x2="100.074"
                        y2="131.694"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint19_linear_1_8"
                        x1="48.6043"
                        y1="60.7125"
                        x2="212.02"
                        y2="60.7125"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint20_linear_1_8"
                        x1="43.4875"
                        y1="71.4611"
                        x2="208.362"
                        y2="71.4611"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint21_linear_1_8"
                        x1="185.864"
                        y1="103.268"
                        x2="243.221"
                        y2="103.268"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop offset="0.00359712" stop-color="#E38DDD"/>
                        <stop offset="1" stop-color="#9571F6"/>
                    </linearGradient>
                    <linearGradient
                        id="paint22_linear_1_8"
                        x1="219.587"
                        y1="164.848"
                        x2="209.564"
                        y2="310.691"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FFC444"/>
                        <stop offset="0.9964" stop-color="#F36F56"/>
                    </linearGradient>
                    <linearGradient
                        id="paint23_linear_1_8"
                        x1="197.852"
                        y1="210.676"
                        x2="252.685"
                        y2="210.676"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stop-color="#FF9085"/>
                        <stop offset="1" stop-color="#FB6FBB"/>
                    </linearGradient>
                </defs>
            </svg>
        </div>

        <p class="update_info title">System is resetting</p>
        <p class="update_info">Please reload this page and try again.</p>
        <a href="{{url('/')}}" class="reload_btn">Reload</a>
    </div>
</div>
</body>
</html>
